﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Reader.Abstract;
using BMS.VistaWorker.Data;

namespace BMS.VistaWorker.Reader.Abstract
{
    /// <summary>
    /// Repository interface that exposes the logic to access the data store.
    /// </summary>
    public interface IRepository : IDisposable
    {
        /// <summary>
        /// Opens the repositoty. 
        /// </summary>
        /// <returns></returns>
        IRepository Open();

        /// <summary>
        /// Gets the entities that have create date time less than a specified date time.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <returns></returns>
        IEnumerable<ILogData> GetLogEntities();

        /// <summary>
        /// Deletes the specified entity from data source.
        /// </summary>
        /// <typeparam name="T">The entity type</typeparam>
        /// <param name="entity">The entity.</param>
        /// <exception cref="ReaderConnectionLostException">Connection to writer has been lost.</exception>
        void Delete(ILogData entity);

        /// <summary>
        /// Closes the repository.
        /// </summary>
        void Close();

    }
}
